<?php


$options = array(
	'colormag_button_color_group'            => array(
		'type'         => 'customind-color-group',
		'title'        => esc_html__( 'Color', 'colormag' ),
		'section'      => 'colormag_button_section',
		'sub_controls' => apply_filters(
			'colormag_button_color_controls',
			array(
				'colormag_button_color'       => array(
					'default'   => '#ffffff',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Normal', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_button_section',
				),
				'colormag_button_hover_color' => array(
					'default'   => '',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Hover', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_button_section',
				),
			)
		),
	),
	'colormag_button_background_color_group' => array(
		'type'         => 'customind-color-group',
		'title'        => esc_html__( 'Background', 'colormag' ),
		'section'      => 'colormag_button_section',
		'sub_controls' => apply_filters(
			'colormag_button_background_color_controls',
			array(
				'colormag_button_background_color'       => array(
					'default'   => 'var(--cm-color-1)',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Normal', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_button_section',
				),
				'colormag_button_background_hover_color' => array(
					'default'   => '',
					'type'      => 'customind-color',
					'title'     => esc_html__( 'Hover', 'colormag' ),
					'transport' => 'postMessage',
					'section'   => 'colormag_button_section',
				),
			)
		),
	),
	'colormag_button_typography'             => array(
		'default'   => array(
			'font-family'    => 'inherit',
			'font-weight'    => '400',
			'font-size'      => array(
				'desktop' => array(
					'size' => '12',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		),
		'type'      => 'customind-typography',
		'transport' => 'postMessage',
		'title'     => esc_html__( 'Typography', 'colormag' ),
		'section'   => 'colormag_button_section',
	),
	'colormag_button_dimension_subtitle'     => array(
		'type'    => 'customind-divider',
		'variant' => 'dashed',
		'section' => 'colormag_button_section',
	),
	'colormag_button_dimension_padding'      => array(
		'default'     => array(
			'top'    => '',
			'right'  => '',
			'bottom' => '',
			'left'   => '',
			'unit'   => 'px',
		),
		'type'        => 'customind-dimensions',
		'title'       => esc_html__( 'Padding', 'colormag' ),
		'section'     => 'colormag_button_section',
		'transport'   => 'postMessage',
		'units'       => array( 'px', 'em' ),
		'defaultUnit' => 'px',
	),
	'colormag_button_border_divider'         => array(
		'type'    => 'customind-divider',
		'variant' => 'dashed',
		'section' => 'colormag_button_section',
	),
	'colormag_button_border_subtitle'        => array(
		'title'   => esc_html__( 'Border', 'colormag' ),
		'type'    => 'customind-title',
		'section' => 'colormag_button_section',
	),
	'colormag_button_border_style'           => array(
		'default' => 'none',
		'type'    => 'customind-select',
		'title'   => esc_html__( 'Style', 'colormag' ),
		'section' => 'colormag_button_section',
		'choices' => array(
			'none'   => esc_html__( 'None', 'colormag' ),
			'solid'  => esc_html__( 'Solid', 'colormag' ),
			'double' => esc_html__( 'Double', 'colormag' ),
			'dashed' => esc_html__( 'Dashed', 'colormag' ),
			'dotted' => esc_html__( 'Dotted', 'colormag' ),
		),
	),
	'colormag_button_border_width'           => array(
		'default'     => array(
			'size' => '',
			'unit' => 'px',
		),
		'type'        => 'customind-slider',
		'title'       => esc_html__( 'Width', 'colormag' ),
		'section'     => 'colormag_button_section',
		'transport'   => 'postMessage',
		'units'       => array( 'px' ),
		'defaultUnit' => 'px',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 10,
			'step' => 1,
		),
		'condition'   => array(
			'colormag_button_border_style!' => 'none',
		),
	),
	'colormag_button_border_color_group'     => array(
		'type'         => 'customind-color-group',
		'title'        => esc_html__( 'Color', 'colormag' ),
		'section'      => 'colormag_button_section',
		'sub_controls' => apply_filters(
			'colormag_button_border_color_controls',
			array(
				'colormag_button_border_color'       => array(
					'default' => '',
					'type'    => 'customind-color',
					'title'   => esc_html__( 'Color', 'colormag' ),
					'section' => 'colormag_button_section',
				),
				'colormag_button_border_hover_color' => array(
					'default' => '',
					'type'    => 'customind-color',
					'title'   => esc_html__( 'Hover', 'colormag' ),
					'section' => 'colormag_button_section',
				),
			)
		),
		'condition'    => array(
			'colormag_button_border_style!' => 'none',
		),
	),
	'colormag_button_border_radius'          => array(
		'default'     => array(
			'size' => '3',
			'unit' => 'px',
		),
		'type'        => 'customind-slider',
		'title'       => esc_html__( 'Radius', 'colormag' ),
		'section'     => 'colormag_button_section',
		'transport'   => 'postMessage',
		'units'       => array( 'px' ),
		'defaultUnit' => 'px',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 50,
			'step' => 1,
		),
		'condition'   => array(
			'colormag_button_border_style!' => 'none',
		),
	),
);

colormag_customind()->add_controls( $options );
